package ru.yandex.zora.proxy;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.CodingErrorAction;
import java.util.List;

import org.apache.http.HttpStatus;

import org.apache.http.entity.ContentType;

import org.apache.http.nio.entity.NByteArrayEntity;

import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.http.proxy.ProxySession;

import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.nio.NByteArrayEntityFactory;

import ru.yandex.io.DecodableByteArrayOutputStream;

import ru.yandex.json.writer.JsonType;
import ru.yandex.json.writer.JsonTypeExtractor;
import ru.yandex.json.writer.JsonWriter;

public class ImageResultPrinter
    extends AbstractProxySessionCallback<List<Image>>
{
    private final JsonType jsonType;

    public ImageResultPrinter(
        final ProxySession session)
        throws BadRequestException
    {
        super(session);

        jsonType = JsonTypeExtractor.NORMAL.extract(session.params());
    }

    private void writeImage(
        final JsonWriter writer,
        final Image image)
        throws IOException
    {
        writer.startObject();
        writer.key("width");
        writer.value(image.width());
        writer.key("height");
        writer.value(image.height());
        writer.endObject();
    }

    public void completed(final Image image) {
        DecodableByteArrayOutputStream out =
            new DecodableByteArrayOutputStream();
        try (OutputStreamWriter outWriter =
                 new OutputStreamWriter(
                     out,
                     session.acceptedCharset().newEncoder()
                         .onMalformedInput(CodingErrorAction.REPLACE)
                         .onUnmappableCharacter(CodingErrorAction.REPLACE));
             JsonWriter writer = jsonType.create(outWriter))
        {
            writeImage(writer, image);
        } catch (IOException e) {
            failed(e);
            return;
        }

        NByteArrayEntity entity =
            out.processWith(NByteArrayEntityFactory.INSTANCE);
        entity.setContentType(
            ContentType.APPLICATION_JSON.withCharset(
                session.acceptedCharset())
                .toString());
        session.response(HttpStatus.SC_OK, entity);
    }

    @Override
    public void completed(final List<Image> images) {
        DecodableByteArrayOutputStream out =
            new DecodableByteArrayOutputStream();
        try (OutputStreamWriter outWriter =
                 new OutputStreamWriter(
                     out,
                     session.acceptedCharset().newEncoder()
                         .onMalformedInput(CodingErrorAction.REPLACE)
                         .onUnmappableCharacter(CodingErrorAction.REPLACE));
             JsonWriter writer = jsonType.create(outWriter))
        {
            writer.startArray();
            for (Image image: images) {
                writeImage(writer, image);
            }
            writer.endArray();
        } catch (IOException e) {
            failed(e);
            return;
        }

        NByteArrayEntity entity =
            out.processWith(NByteArrayEntityFactory.INSTANCE);
        entity.setContentType(
            ContentType.APPLICATION_JSON.withCharset(
                session.acceptedCharset())
                .toString());
        session.response(HttpStatus.SC_OK, entity);
    }

    public void completed(final int status) {
        session.response(status);
    }

    public void completed(final int status, final String message) {
        session.response(status, message);
    }
}
