package ru.yandex.zora.proxy;

import java.util.List;
import java.util.logging.Level;

import org.apache.http.concurrent.FutureCallback;
import ru.yandex.http.proxy.ProxySession;

public class ImageWaitingLoadCallback extends BaseImageLoadCallback {
    protected final FutureCallback<Image> callback;
    protected final DownloadTask task;

    // CSOFF: ParameterNumber
    public ImageWaitingLoadCallback(
        final FutureCallback<Image> callback,
        final ProxySession session,
        final ZoraCache cache,
        final DownloadTask task)
    {
        super(cache, session.logger(), task.url());

        this.callback = callback;
        this.task = task;
    }
    // CSON: ParameterNumber

    public DownloadTask task() {
        return task;
    }

    @Override
    public void completed(final Image image) {
        super.completed(image);

        List<FutureCallback<Image>> callbacks;
        synchronized (task) {
            task.finish(image);
            callbacks = task.callbacks();
            callbacks.add(callback);
        }

        for (FutureCallback<Image> cb: callbacks) {
            cb.completed(image);
        }
    }

    protected void failed(final Exception e, final boolean check) {
        Image image = null;

        if (check
            && ZoraErrorType.ERROR_CLASSIFIER.apply(e)
            == ZoraErrorType.NON_RETRIABLE)
        {
            logger.log(
                Level.WARNING,
                url + " fetch failed with nonretriable error",
                e);

            image = new Image(-1, -1);
        }

        if (image != null) {
            completed(image);
        } else {
            super.failed(e);

            List<FutureCallback<Image>> callbacks;
            synchronized (task) {
                task.finish(null);
                callbacks = task.callbacks();
                callbacks.add(callback);
            }

            for (FutureCallback<Image> cb: callbacks) {
                cb.failed(e);
            }
        }
    }

    @Override
    public void failed(final Exception e) {
        failed(e, true);
    }

    @Override
    public void cancelled() {
        super.cancelled();

        List<FutureCallback<Image>> callbacks;
        synchronized (task) {
            task.finish(null);
            callbacks = task.callbacks();
            callbacks.add(callback);
        }

        for (FutureCallback<Image> cb: callbacks) {
            cb.cancelled();
        }
    }
}
