package ru.yandex.zora.proxy;

import java.util.List;

import org.apache.http.concurrent.FutureCallback;

public class MissfitsWaitingLoadCallback implements FutureCallback<Image> {
    private final ImageWaitingLoadCallback cb;

    public MissfitsWaitingLoadCallback(
        final ImageWaitingLoadCallback callback)
    {
        this.cb = callback;
    }

    @Override
    public void failed(final Exception e) {
        cb.failed(e, true);
    }

    public void failed(final Image image) {
        cb.cache.pending().remove(cb.url);
        cb.logger.info(cb.url + " missfit image fetch failed ");

        List<FutureCallback<Image>> callbacks;
        synchronized (cb.task) {
            cb.task.finish(image);
            callbacks = cb.task.callbacks();
            callbacks.add(cb.callback);
        }

        for (FutureCallback<Image> cb: callbacks) {
            cb.completed(image);
        }
    }

    @Override
    public void completed(final Image image) {
        cb.completed(image);
    }

    @Override
    public void cancelled() {
        cb.cancelled();
    }

    public DownloadTask task() {
        return cb.task();
    }
}
