package ru.yandex.zora.proxy;

import java.io.IOException;
import java.io.InterruptedIOException;

import java.net.SocketTimeoutException;
import java.net.UnknownHostException;

import java.util.concurrent.TimeoutException;
import java.util.function.Function;

import org.apache.http.ProtocolException;

import ru.yandex.http.util.BadResponseException;
import ru.yandex.http.util.ServerErrorStatusPredicate;

public enum ZoraErrorType {
    NON_RETRIABLE,
    RETRIABLE;

    private static final int ZORA_QUOTA = 407;

    public static final Function<Exception, ZoraErrorType>
        ERROR_CLASSIFIER =
        new Function<Exception, ZoraErrorType>() {
            @Override
            public ZoraErrorType apply(final Exception e) {
                ZoraErrorType type;
                if (e instanceof IOException) {
                    if (e instanceof SocketTimeoutException) {
                        type = RETRIABLE;
                    } else if (e instanceof InterruptedIOException) {
                        type = NON_RETRIABLE;
                    } else if (e instanceof UnknownHostException) {
                        type = NON_RETRIABLE;
                    } else {
                        type = RETRIABLE;
                    }
                } else if (e instanceof TimeoutException) {
                    type = RETRIABLE;
                } else if (e instanceof BadResponseException) {
                    int status = ((BadResponseException) e).statusCode();
                    if (status == ZORA_QUOTA) {
                        type = RETRIABLE;
                    } else if (ServerErrorStatusPredicate.INSTANCE.test(
                        status))
                    {
                        type = RETRIABLE;
                    } else {
                        type = NON_RETRIABLE;
                    }
                } else if (e instanceof ProtocolException) {
                    type = NON_RETRIABLE;
                } else {
                    type = RETRIABLE;
                }
                return type;
            }
        };
}
