package ru.yandex.zora.proxy;

import java.io.IOException;

import org.apache.http.HttpException;
import org.apache.http.HttpResponse;

import org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import org.apache.http.nio.protocol.HttpAsyncResponseConsumer;

import ru.yandex.http.util.nio.HttpAsyncResponseConsumerFactory;

public class ZoraResultConsumerFactory
    implements HttpAsyncResponseConsumerFactory<Image>
{
    private final ZoraProxy zoraProxy;

    public ZoraResultConsumerFactory(final ZoraProxy proxy) {
        this.zoraProxy = proxy;
    }

    @Override
    public HttpAsyncResponseConsumer<Image> create(
        final HttpAsyncRequestProducer producer,
        final HttpResponse response)
        throws HttpException, IOException
    {
        return new ZoraResultConsumer(zoraProxy);
    }
}
