package ru.yandex.zora.proxy.config;

import ru.yandex.client.tvm2.ImmutableTvm2ClientConfig;

import ru.yandex.http.config.ImmutableHttpTargetConfig;

import ru.yandex.http.util.server.ImmutableHttpProxyConfig;

import ru.yandex.parser.config.ConfigException;

public class ImmutableZoraProxyConfig
    extends ImmutableHttpProxyConfig
    implements ZoraProxyConfig
{
    private final long expirePeriod;
    private final ImmutableHttpTargetConfig zoraclConfig;
    private final ImmutableTvm2ClientConfig tvm2Config;
    private final long maxImageSize;
    private final String source;
    private final int maxCacheSize;
    private final int zoraHostResponseTimeout;
    private final String cacheDumpLocation;
    private final int zoraRpsLimit;
    private final int suspiciousQueueSize;

    public ImmutableZoraProxyConfig(
        final ZoraProxyConfig config)
        throws ConfigException
    {
        super(config);
        forceTvm2ServiceConfig();

        this.source = config.source();
        this.expirePeriod = config.expirePeriod();
        this.maxImageSize = config.maxImageSize();
        this.zoraclConfig =
            new ImmutableHttpTargetConfig(config.zoraclConfig());
        this.maxCacheSize = config.maxCacheSize();
        this.cacheDumpLocation = config.cacheDumpLocation();
        this.zoraHostResponseTimeout = config.zoraResponseTimeout();
        this.zoraRpsLimit = config.zoraRpsLimit();
        this.suspiciousQueueSize = config.suspiciousQueueSize();
        this.tvm2Config = new ImmutableTvm2ClientConfig(config.tvm2Config());
    }

    @Override
    public long expirePeriod() {
        return expirePeriod;
    }

    @Override
    public ImmutableHttpTargetConfig zoraclConfig() {
        return zoraclConfig;
    }

    @Override
    public long maxImageSize() {
        return maxImageSize;
    }

    @Override
    public String source() {
        return source;
    }

    @Override
    public int maxCacheSize() {
        return maxCacheSize;
    }

    @Override
    public String cacheDumpLocation() {
        return cacheDumpLocation;
    }

    @Override
    public int zoraResponseTimeout() {
        return zoraHostResponseTimeout;
    }

    @Override
    public int zoraRpsLimit() {
        return zoraRpsLimit;
    }

    @Override
    public int suspiciousQueueSize() {
        return suspiciousQueueSize;
    }

    @Override
    public ImmutableTvm2ClientConfig tvm2Config() {
        return tvm2Config;
    }
}
