package ru.yandex.zora.proxy.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class ZoraProxyConfigBuilder
    extends AbstractZoraProxyConfigBuilder<ZoraProxyConfigBuilder>
{
    public ZoraProxyConfigBuilder() {
        super(ZoraProxyConfigDefaults.INSTANCE);
    }

    public ZoraProxyConfigBuilder(
        final IniConfig config)
        throws ConfigException
    {
        this(config, ZoraProxyConfigDefaults.INSTANCE);
    }

    public ZoraProxyConfigBuilder(final ZoraProxyConfig config) {
        super(config);
    }

    public ZoraProxyConfigBuilder(
        final IniConfig config,
        final ZoraProxyConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public ZoraProxyConfigBuilder self() {
        return this;
    }

    public ImmutableZoraProxyConfig build() throws ConfigException {
        return new ImmutableZoraProxyConfig(this);
    }
}
