package ru.yandex.zora.proxy.config;

import ru.yandex.client.tvm2.Tvm2ClientConfig;
import ru.yandex.client.tvm2.Tvm2ClientConfigDefaults;

import ru.yandex.http.config.HttpTargetConfig;
import ru.yandex.http.config.HttpTargetConfigDefaults;

import ru.yandex.http.util.server.HttpProxyConfigDefaults;

public class ZoraProxyConfigDefaults
    extends HttpProxyConfigDefaults
    implements ZoraProxyConfig
{
    public static final ZoraProxyConfigDefaults INSTANCE =
        new ZoraProxyConfigDefaults();

    private static final long DEFAULT_EXPIRE_SECONDS = 60 * 60 * 24;
    private static final long MAX_IMAGE_SIZE = 10 * 1000 * 1000;
    private static final String DEFAULT_SOURCE = "ps_mail_iex";
    private static final int MAX_CACHE_SIZE = 7000000;
    private static final int ZORA_HOST_RESPONSE_TO = 120;
    private static final int ZORA_RPS_LIMIT = -1;
    private static final int SUSPICIOUS_QUEUE_SIZE = 1000;

    @Override
    public HttpTargetConfig zoraclConfig() {
        return HttpTargetConfigDefaults.INSTANCE;
    }

    @Override
    public long expirePeriod() {
        return DEFAULT_EXPIRE_SECONDS;
    }

    @Override
    public long maxImageSize() {
        return MAX_IMAGE_SIZE;
    }

    @Override
    public String source() {
        return DEFAULT_SOURCE;
    }

    @Override
    public int maxCacheSize() {
        return MAX_CACHE_SIZE;
    }

    @Override
    public String cacheDumpLocation() {
        return null;
    }

    @Override
    public int zoraResponseTimeout() {
        return ZORA_HOST_RESPONSE_TO;
    }

    @Override
    public int zoraRpsLimit() {
        return ZORA_RPS_LIMIT;
    }

    @Override
    public int suspiciousQueueSize() {
        return SUSPICIOUS_QUEUE_SIZE;
    }

    @Override
    public Tvm2ClientConfig tvm2Config() {
        return Tvm2ClientConfigDefaults.INSTANCE;
    }
}
