#!/bin/bash

function generateConfig() {
cat <<HERE_CONFIG
package $PACKAGE;

import ru.yandex.search.proxy.universal.UniversalSearchProxyConfig;

public interface ${PROJECT_NAME}Config extends UniversalSearchProxyConfig {
}
HERE_CONFIG
}

function generateImmutableConfig() {
cat <<HERE_CONFIG
package $PACKAGE;

import ru.yandex.parser.config.ConfigException;

import ru.yandex.search.proxy.universal.ImmutableUniversalSearchProxyConfig;

public class Immutable${PROJECT_NAME}Config
    extends ImmutableUniversalSearchProxyConfig
    implements ${PROJECT_NAME}Config
{
    public Immutable${PROJECT_NAME}Config(
        final ${PROJECT_NAME}Config config)
        throws ConfigException
    {
        super(config);
    }
}
HERE_CONFIG
}

function generateAbstractConfigBuilder() {
cat <<HERE_CONFIG
package $PACKAGE;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

import ru.yandex.search.proxy.universal.AbstractUniversalSearchProxyConfigBuilder;

public abstract class Abstract${PROJECT_NAME}ConfigBuilder
    <T extends Abstract${PROJECT_NAME}ConfigBuilder<T>>
    extends AbstractUniversalSearchProxyConfigBuilder<T>
    implements ${PROJECT_NAME}Config
{
    public Abstract${PROJECT_NAME}ConfigBuilder(
        final ${PROJECT_NAME}Config config)
        throws ConfigException
    {
        super(config);
    }

    public Abstract${PROJECT_NAME}ConfigBuilder(
        final IniConfig config,
        final ${PROJECT_NAME}Config defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    public void copyTo(final Abstract${PROJECT_NAME}ConfigBuilder<?> other) {
        copyTo((AbstractUniversalSearchProxyConfigBuilder<?>) other);
    }
}
HERE_CONFIG
}

function generateConfigBuilder() {
cat <<HERE_CONFIG
package $PACKAGE;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class ${PROJECT_NAME}ConfigBuilder
    extends Abstract${PROJECT_NAME}ConfigBuilder<
        ${PROJECT_NAME}ConfigBuilder>
{
    public ${PROJECT_NAME}ConfigBuilder()
        throws ConfigException
    {
        super(${PROJECT_NAME}ConfigDefaults.INSTANCE);
    }

    public ${PROJECT_NAME}ConfigBuilder(
        final ${PROJECT_NAME}Config config)
        throws ConfigException
    {
        super(config);
    }

    public ${PROJECT_NAME}ConfigBuilder(
        final IniConfig config)
        throws ConfigException
    {
        this(config, ${PROJECT_NAME}ConfigDefaults.INSTANCE);
    }

    public ${PROJECT_NAME}ConfigBuilder(
        final IniConfig config,
        final ${PROJECT_NAME}Config defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public ${PROJECT_NAME}ConfigBuilder self() {
        return this;
    }

    public Immutable${PROJECT_NAME}Config build()
        throws ConfigException
    {
        return new Immutable${PROJECT_NAME}Config(this);
    }
}
HERE_CONFIG
}

function generateConfigDefaults() {
cat <<HERE_CONFIG
package $PACKAGE;

import ru.yandex.search.proxy.universal.UniversalSearchProxyConfigDefaults;

public class ${PROJECT_NAME}ConfigDefaults
    extends UniversalSearchProxyConfigDefaults
    implements ${PROJECT_NAME}Config
{
    public static final ${PROJECT_NAME}ConfigDefaults INSTANCE =
        new ${PROJECT_NAME}ConfigDefaults();

    protected ${PROJECT_NAME}ConfigDefaults() {
    }
}
HERE_CONFIG
}

function generateServerClass() {
cat <<HERE_CONFIG
package $PACKAGE;

import java.io.IOException;

import ru.yandex.search.proxy.universal.UniversalSearchProxy;

public class ${PROJECT_NAME} extends UniversalSearchProxy {
    public ${PROJECT_NAME}(final Immutable${PROJECT_NAME}Config config)
        throws IOException
    {
        super(config);
    }
}

HERE_CONFIG
}

export PACKAGE="ru.yandex.search.messenger.proxy";
export PROJECT_NAME="Moxy";

SRC_DIR="src/${PROJECT_NAME,,}/main/java/${PACKAGE//.///}"

mkdir -p $SRC_DIR

generateConfig > $SRC_DIR/${PROJECT_NAME}Config.java
generateImmutableConfig > $SRC_DIR/Immutable${PROJECT_NAME}Config.java
generateConfigBuilder > $SRC_DIR/${PROJECT_NAME}ConfigBuilder.java
generateAbstractConfigBuilder > $SRC_DIR/Abstract${PROJECT_NAME}ConfigBuilder.java
generateConfigDefaults > $SRC_DIR/${PROJECT_NAME}ConfigDefaults.java
generateServerClass > $SRC_DIR/${PROJECT_NAME}.java
