package ru.yandex.client.producer;

import ru.yandex.http.config.AbstractHttpHostConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractProducerClientConfigBuilder
    <T extends AbstractProducerClientConfigBuilder<T>>
    extends AbstractHttpHostConfigBuilder<T>
    implements ProducerClientConfig
{
    private boolean allowCached;
    private boolean fallbackToSearchMap;
    private boolean streaming;
    private long maxTotalTime;
    private long failoverDelay;
    private long cacheTtl;
    private long cacheUpdateInterval;

    protected AbstractProducerClientConfigBuilder(
        final ProducerClientConfig config)
    {
        super(config);
        allowCached = config.allowCached();
        fallbackToSearchMap = config.fallbackToSearchMap();
        streaming = config.streaming();
        maxTotalTime = config.maxTotalTime();
        failoverDelay = config.failoverDelay();
        cacheTtl = config.cacheTtl();
        cacheUpdateInterval = config.cacheUpdateInterval();
    }

    protected AbstractProducerClientConfigBuilder(
        final IniConfig config,
        final ProducerClientConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
        allowCached =
            config.getBoolean("allow-cached", defaults.allowCached());
        fallbackToSearchMap = config.getBoolean(
            "fallback-to-searchmap",
            defaults.fallbackToSearchMap());
        streaming =
            config.getBoolean("streaming", defaults.streaming());
        maxTotalTime =
            config.getLongDuration("max-total-time", defaults.maxTotalTime());
        failoverDelay =
            config.getLongDuration("failover-delay", defaults.failoverDelay());
        cacheTtl =
            config.getLongDuration("cache-ttl", defaults.cacheTtl());
        cacheUpdateInterval = config.getLongDuration(
                    "cache-update-interval",
                    defaults.cacheUpdateInterval());
    }

    @Override
    public boolean allowCached() {
        return allowCached;
    }

    public T allowCached(final boolean allowCached) {
        this.allowCached = allowCached;
        return self();
    }

    @Override
    public boolean fallbackToSearchMap() {
        return fallbackToSearchMap;
    }

    public T fallbackToSearchMap(final boolean fallbackToSearchMap) {
        this.fallbackToSearchMap = fallbackToSearchMap;
        return self();
    }

    @Override
    public long maxTotalTime() {
        return maxTotalTime;
    }

    public T maxTotalTime(final long maxTotalTime) {
        this.maxTotalTime = maxTotalTime;
        return self();
    }

    @Override
    public long failoverDelay() {
        return failoverDelay;
    }

    public T failoverDelay(final long failoverDelay) {
        this.failoverDelay = failoverDelay;
        return self();
    }

    @Override
    public long cacheTtl() {
        return cacheTtl;
    }

    public T cacheTtl(final long cacheTtl) {
        this.cacheTtl = cacheTtl;
        return self();
    }

    @Override
    public long cacheUpdateInterval() {
        return cacheUpdateInterval;
    }

    public T cacheUpdateInterval(final long cacheUpdateInterval) {
        this.cacheUpdateInterval = cacheUpdateInterval;
        return self();
    }

    @Override
    public boolean streaming() {
        return streaming;
    }

    public T streaming(final boolean streaming) {
        this.streaming = streaming;
        return self();
    }
}

