package ru.yandex.client.producer;

import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.parser.config.ConfigException;

public class ImmutableProducerClientConfig
    extends ImmutableHttpHostConfig
    implements ProducerClientConfig
{
    private final boolean allowCached;
    private final boolean fallbackToSearchMap;
    private final boolean streaming;
    private final long maxTotalTime;
    private final long failoverDelay;
    private final long cacheTtl;
    private final long cacheUpdateInterval;

    public ImmutableProducerClientConfig(final ProducerClientConfig config)
        throws ConfigException
    {
        super(config);
        allowCached = config.allowCached();
        fallbackToSearchMap = config.fallbackToSearchMap();
        streaming = config.streaming();
        maxTotalTime = config.maxTotalTime();
        failoverDelay = config.failoverDelay();
        cacheTtl = config.cacheTtl();
        cacheUpdateInterval = config.cacheUpdateInterval();

        if (maxTotalTime < 0L) {
            throw new ConfigException("max total time is not set");
        }
        if (failoverDelay < 0L) {
            throw new ConfigException("failover delay is not set");
        }
    }

    @Override
    public boolean allowCached() {
        return allowCached;
    }

    @Override
    public boolean fallbackToSearchMap() {
        return fallbackToSearchMap;
    }

    @Override
    public long maxTotalTime() {
        return maxTotalTime;
    }

    @Override
    public long failoverDelay() {
        return failoverDelay;
    }

    @Override
    public long cacheTtl() {
        return cacheTtl;
    }

    @Override
    public long cacheUpdateInterval() {
        return cacheUpdateInterval;
    }

    @Override
    public boolean streaming() {
        return streaming;
    }
}

