package ru.yandex.client.producer;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class ProducerClientConfigBuilder
    extends AbstractProducerClientConfigBuilder<ProducerClientConfigBuilder>
{
    public ProducerClientConfigBuilder() {
        super(ProducerClientConfigDefaults.INSTANCE);
    }

    public ProducerClientConfigBuilder(final ProducerClientConfig config) {
        super(config);
    }

    public ProducerClientConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        super(config, ProducerClientConfigDefaults.INSTANCE);
    }

    public ProducerClientConfigBuilder(
        final IniConfig config,
        final ProducerClientConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public ProducerClientConfigBuilder self() {
        return this;
    }

    public ImmutableProducerClientConfig build() throws ConfigException {
        return new ImmutableProducerClientConfig(this);
    }
}

