package ru.yandex.client.producer;

import java.io.Serializable;

import org.apache.http.HttpHost;

import ru.yandex.function.AbstractStringBuilderable;
import ru.yandex.http.util.HttpHostAppender;

public class QueueHostInfo
    extends AbstractStringBuilderable
    implements Serializable, Comparable<QueueHostInfo>
{
    private static final long DEFAULT_QUEUE_ID = Integer.MIN_VALUE;
    private static final long serialVersionUID = 0L;

    private final HttpHost host;
    private long queueId;

    public QueueHostInfo(final HttpHost host) {
        this(host, DEFAULT_QUEUE_ID);
    }

    public QueueHostInfo(final QueueHostInfo info) {
        this.host = info.host;
        this.queueId = info.queueId;
    }

    public QueueHostInfo(final HttpHost host, final long queueId) {
        this.host = host;
        this.queueId = queueId;
    }

    public HttpHost host() {
        return host;
    }

    public long queueId() {
        return queueId;
    }

    public QueueHostInfo queueId(final long queueId) {
        this.queueId = queueId;
        return this;
    }

    @Override
    public int hashCode() {
        return host.hashCode() ^ Long.hashCode(queueId);
    }

    @Override
    public boolean equals(final Object o) {
        if (o instanceof QueueHostInfo) {
            final QueueHostInfo other = (QueueHostInfo) o;
            return other.host.equals(host) && other.queueId == queueId;
        }
        return false;
    }

    @Override
    public void toStringBuilder(final StringBuilder sb) {
        HttpHostAppender.appendTo(sb, host);
        sb.append('@');
        sb.append(queueId);
    }

    @Override
    public int compareTo(final QueueHostInfo o) {
        return Long.compare(o.queueId, this.queueId);
    }
}
