package ru.yandex.client.producer;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.protocol.HttpContext;

import ru.yandex.json.async.consumer.JsonAsyncConsumer;
import ru.yandex.json.parser.StringCollectorsFactory;
import ru.yandex.json.xpath.PathComponent;
import ru.yandex.json.xpath.PrimitiveHandler;

public class ZoolooserJsonStatusConsumer
    extends JsonAsyncConsumer<List<QueueHostInfo>>
{
    private final HostsBuilder builder;

    public ZoolooserJsonStatusConsumer(
        final HttpEntity entity,
        final Map<String, QueueHostInfo> searchMapHosts)
        throws HttpException
    {
        this(entity, new HostsBuilder(searchMapHosts));
    }

    private ZoolooserJsonStatusConsumer(
        final HttpEntity entity,
        final HostsBuilder builder)
        throws HttpException
    {
        super(entity, builder, StringCollectorsFactory.INSTANCE);
        this.builder = builder;
    }

    @Override
    protected List<QueueHostInfo> doBuildResult(final HttpContext context) {
        return builder;
    }

    private static class HostsBuilder
        extends ArrayList<QueueHostInfo>
        implements PrimitiveHandler
    {
        private static final long serialVersionUID = 0L;

        private final Map<String, QueueHostInfo> searchMapHosts;

        HostsBuilder(final Map<String, QueueHostInfo> searchMapHosts) {
            super(searchMapHosts.size());
            this.searchMapHosts = searchMapHosts;
        }

        @Override
        public void handle(
            final List<PathComponent> path,
            final Object value)
        {
            if (value instanceof Number) {
                QueueHostInfo host =
                    searchMapHosts.get(path.get(path.size() - 1).name());
                if (host != null) {
                    add(host.queueId(((Number) value).longValue()));
                }
            }
        }
    }
}

