package ru.yandex.client.producer;

import java.util.List;
import java.util.Map;

import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;

import ru.yandex.http.util.nio.HttpAsyncResponseConsumerFactory;

public class ZoolooserJsonStatusConsumerFactory
    implements HttpAsyncResponseConsumerFactory<List<QueueHostInfo>>
{
    private final Map<String, QueueHostInfo> searchMapHosts;

    protected ZoolooserJsonStatusConsumerFactory(
        final Map<String, QueueHostInfo> searchMapHosts)
    {
        this.searchMapHosts = searchMapHosts;
    }

    @Override
    public ZoolooserJsonStatusConsumer create(
        final HttpAsyncRequestProducer producer,
        final HttpResponse response)
        throws HttpException
    {
        return new ZoolooserJsonStatusConsumer(
            response.getEntity(),
            searchMapHosts);
    }
}

