package ru.yandex.client.producer;

import java.util.List;

import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.protocol.HttpContext;

import ru.yandex.json.async.consumer.JsonAsyncConsumer;
import ru.yandex.json.parser.StringCollectorsFactory;
import ru.yandex.json.xpath.PathComponent;
import ru.yandex.json.xpath.PrimitiveHandler;

public class ZoolooserJsonStatusStreamConsumer
    extends JsonAsyncConsumer<Object>
{
    private final StatusBuilder builder;

    public ZoolooserJsonStatusStreamConsumer(
        final HttpEntity entity,
        final StatusCallback callback)
        throws HttpException
    {
        this(entity, new StatusBuilder(callback));
    }

    private ZoolooserJsonStatusStreamConsumer(
        final HttpEntity entity,
        final StatusBuilder builder)
        throws HttpException
    {
        super(entity, builder, StringCollectorsFactory.INSTANCE);
        this.builder = builder;
    }

    @Override
    protected Object doBuildResult(final HttpContext context) {
        return builder;
    }

    private static class StatusBuilder
        implements PrimitiveHandler
    {
        private final StatusCallback callback;
        private int prevIdx = -1;
        private String host;
        private String shard;
        private long hostPos;

        StatusBuilder(final StatusCallback callback) {
            this.callback = callback;
        }

        @Override
        public void handle(
            final List<PathComponent> path,
            final Object value)
        {
            int idx = path.get(0).index();
            if (idx != prevIdx) {
                if (host != null && shard != null
                    && hostPos != Long.MIN_VALUE)
                {
//                    System.err.println(shard + '@' + host + ": " + hostPos);
                    callback.status(host, Integer.parseInt(shard), hostPos);
                }
                host = null;
                shard = null;
                hostPos = Long.MIN_VALUE;
                prevIdx = idx;
            }
            if ("host".equals(path.get(1).name())) {
                host = String.valueOf(value);
            } else if ("shard".equals(path.get(1).name())) {
                shard = String.valueOf(value);
            } else if ("data".equals(path.get(1).name())) {
                if (value instanceof Number) {
                    hostPos = ((Number) value).longValue();
                } else {
                    hostPos = Long.parseLong(value.toString());
                }
            }
            callback.status(null, 0, 0);
        }
    }
}

