package ru.yandex.client.producer;

import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;

import ru.yandex.http.util.nio.HttpAsyncResponseConsumerFactory;

public class ZoolooserJsonStatusStreamConsumerFactory
    implements HttpAsyncResponseConsumerFactory<Object>
{
    private final StatusCallback callback;

    protected ZoolooserJsonStatusStreamConsumerFactory(
        final StatusCallback callback)
    {
        this.callback = callback;
    }

    @Override
    public ZoolooserJsonStatusStreamConsumer create(
        final HttpAsyncRequestProducer producer,
        final HttpResponse response)
        throws HttpException
    {
        return new ZoolooserJsonStatusStreamConsumer(
            response.getEntity(),
            callback);
    }
}

