package ru.yandex.search.request.util;

import java.util.function.Supplier;

public class BoostByOrderFieldsTermsSupplier implements Supplier<Term> {
    private final Supplier<String> fields;
    private final String token;
    private float boost;
    private float boostExactFromWildcard;

    public BoostByOrderFieldsTermsSupplier(
        final Supplier<String> fields,
        final String token,
        final float initialBoost,
        final float boostExactFromWildcard)
    {
        this.fields = fields;
        this.token = token;
        this.boost = initialBoost;
        this.boostExactFromWildcard = boostExactFromWildcard;
    }

    @Override
    public Term get() {
        String field = fields.get();
        if (field == null) {
            return null;
        } else {
            Term term = new Term(field, token, boost);
            if (boostExactFromWildcard != 0f
                && token.endsWith("*")
                && token.length() > 1)
            {
                term = new OrTerm(
                    field,
                    term,
                    new Term(
                        field,
                        token.substring(0, token.length() - 1),
                        boost * boostExactFromWildcard));
            }
            boost *= 2;
            return term;
        }
    }
}

