package ru.yandex.search.request.util;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

import ru.yandex.function.IteratorSupplierAdapter;

public class BoostByOrderFieldsTermsSupplierFactory
    implements Function<String, BoostByOrderFieldsTermsSupplier>
{
    private final List<String> fields;
    private final float initialBoost;
    private final float boostExactFromWildcard;

    public BoostByOrderFieldsTermsSupplierFactory(
        final float initialBoost,
        final String... fields)
    {
        this(0f, initialBoost, Arrays.asList(fields));
    }

    public BoostByOrderFieldsTermsSupplierFactory(
        final float initialBoost,
        final List<String> fields)
    {
        this(0f, initialBoost, fields);
    }

    public BoostByOrderFieldsTermsSupplierFactory(
        final float boostExactFromWildcard,
        final float initialBoost,
        final String... fields)
    {
        this(boostExactFromWildcard, initialBoost, Arrays.asList(fields));
    }

    public BoostByOrderFieldsTermsSupplierFactory(
        final float boostExactFromWildcard,
        final float initialBoost,
        final List<String> fields)
    {
        this.boostExactFromWildcard = boostExactFromWildcard;
        this.initialBoost = initialBoost;
        this.fields = fields;
    }

    @Override
    public BoostByOrderFieldsTermsSupplier apply(final String token) {
        return new BoostByOrderFieldsTermsSupplier(
            new IteratorSupplierAdapter<>(fields.iterator()),
            token,
            initialBoost,
            boostExactFromWildcard);
    }
}

