package ru.yandex.search.request.util;

import java.util.function.Supplier;

public class FieldsTermsSupplier implements Supplier<Term> {
    private final Supplier<String> fields;
    private final String token;

    public FieldsTermsSupplier(
        final Supplier<String> fields,
        final String token)
    {
        this.fields = fields;
        this.token = token;
    }

    @Override
    public Term get() {
        String field = fields.get();
        if (field == null) {
            return null;
        } else {
            return new Term(field, token);
        }
    }
}

