package ru.yandex.search.request.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.function.Function;

import ru.yandex.function.IteratorSupplierAdapter;

public class FieldsTermsSupplierFactory
    implements Function<String, FieldsTermsSupplier>
{
    private final Collection<String> fields;

    public FieldsTermsSupplierFactory(final String... fields) {
        this(Arrays.asList(fields));
    }

    public FieldsTermsSupplierFactory(final Collection<String> fields) {
        this.fields = fields;
    }

    @Override
    public FieldsTermsSupplier apply(final String token) {
        return new FieldsTermsSupplier(
            new IteratorSupplierAdapter<>(fields.iterator()),
            token);
    }
}

