package ru.yandex.search.request.util;

import java.util.Arrays;
import java.util.List;

public class OrTerm extends Term {
    protected final List<Term> terms;

    public OrTerm(final String field, final Term... terms) {
        this(field, Arrays.asList(terms));
    }

    public OrTerm(final String field, final List<Term> terms) {
        super(field, null);
        this.terms = terms;
    }

    private void addTerm(final StringBuilder sb, final Term term) {
        sb.append(term.token);
        if (term.boost != 0f) {
            sb.append('^');
            sb.append(term.boost);
        }
    }

    @Override
    public void appendTo(final StringBuilder sb) {
        sb.append(field);
        sb.append(':');
        if (terms.size() == 1) {
            addTerm(sb, terms.get(0));
        } else {
            String sep = "";
            sb.append('(');
            for (Term term: terms) {
                sb.append(sep);
                addTerm(sb, term);
                sep = " OR ";
            }
            sb.append(')');
        }
    }
}
