package ru.yandex.search.request.util;

public class Term implements QueryAppender {
    protected final String field;
    protected final String token;
    protected final float boost;

    public Term(final String field, final String token) {
        this.field = field;
        this.token = token;
        boost = 0f;
    }

    public Term(final String field, final String token, final float boost) {
        this.field = field;
        this.token = token;
        this.boost = boost;
    }

    @Override
    public void appendTo(final StringBuilder sb) {
        sb.append(field);
        sb.append(':');
        sb.append(token);
        if (boost != 0f) {
            sb.append('^');
            sb.append(boost);
        }
    }
}

