#!/bin/bash

MAXRATE=15
SEARCHMAP=searchmap_mail.txt
OLDMAP=searchmap-old.txt
SHARDING_FIELDS="__prefix,suid,abook_suid";
THREADS="5"
LOCK_INDEX="false"
DISABLE_INDEXING="true"
CHECK_DUPS="true"
RETRY_COUNT="9"

IHOST=$1;
IPORT=$2;
if [ -z "$IHOST" -o -z "$IPORT" ]; then
    echo "Usage: $0 IHOST IPORT";
    exit 1;
fi

TAG=$IHOST"_"$IPORT
COPY_PORT=$((IPORT+6))

curl -m 10 -s -o /dev/null "http://localhost:$IPORT/ping"
if [ $? -ne 0 ]; then
    echo "Lucene is down";
    exit 1;
fi

jobCount=0;
finishedCount=0;
while read JOB;
do
    jobCount=$((jobCount + 1))
    echo "Checking job: $JOB";
    URL="http://localhost:$IPORT/?copyindex"$JOB"&sharding-fields="$SHARDING_FIELDS
    URL=$URL"&lock-index="$LOCK_INDEX
    URL=$URL"&disable-indexing="$DISABLE_INDEXING
    URL=$URL"&check-dups="$CHECK_DUPS
    URL=$URL"&retry-count="$RETRY_COUNT
    status=$(wget -t 1 -T 20 -qO - $URL&status" | sed 's/<br>//g' | grep -E -e status -e Job | awk '{print $2}')
    if [ $? -ne 0 ]; then
        echo "Error getting job status: wget returned: $?";
        exit 1;
    fi
    if [ "$status" == "does" ]; then
        echo "job does not exists. creating";
        wget -t 1 -T 20 -qO - $URL"&start" | sed 's/<br>//g' | grep -E -e status -e Job | awk '{print $2}'
        if [ $? -eq 0 ]; then
            echo "Success";
        else
            echo "Failed: "$?
            exit 1;
        fi
    elif [ "$status" != "running" -a "$status" != "finished" ]; then
        echo "Job is not running or failed. restarting";
        wget -t 1 -T 20 -qO - $URL"&update" | sed 's/<br>//g' | grep -E -e status -e Job | awk '{print $2}'
        if [ $? -eq 0 ]; then
            echo "Job Update Success";
        else
            echo "Job Update Failed: "$?
            exit 1;
        fi
        wget -t 1 -T 20 -qO - $URL"&start" | sed 's/<br>//g' | grep -E -e status -e Job | awk '{print $2}'
        if [ $? -eq 0 ]; then
            echo "Job start Success";
        else
            echo "Job start Failed: "$?
            exit 1;
        fi
    else
        echo "job is $status"
        if [ "$status" == "finished" ]; then
            finishedCount=$((finishedCount + 1))
        elif [ "$status" == "running" ]; then
            curl -s -m 10 "http://localhost:"$((IPORT+2))"/index-copy-rate-limit?limit="$MAXRATE;
        fi
    fi
done <<< $(if [ -f $OLDMAP ]; cat $OLDMAP; fi; cat $SEARCHMAP | nice -n 20 awk -f generateCopyJobs.awk -v tag=$TAG)

#RO workaround
#if [ $jobCount -eq $finishedCount -a $jobCount -gt 0 ]; then
#    hasRo=`curl -s -m 10 "http://localhost:"$((IPORT+2))"/index-status" | grep RO_USER | tail -1`
#    if [ "$hasRo" != "" ]; then
#        echo "All jobs are finished by index is in RO state. Fixing."
#        curl -s -m 10 "http://localhost"$((IPORT+2))"/flush?rw=true"
#    fi
#fi

