package org.apache.lucene.document;

public class AllFieldSelector implements FieldSelector {
    public static final AllFieldSelector INSTANCE =
        new AllFieldSelector(FieldSelectorResult.LOAD);

    private final FieldSelectorResult fieldSelectorResult;

    public AllFieldSelector(final FieldSelectorResult fieldSelectorResult) {
        this.fieldSelectorResult = fieldSelectorResult;
    }

    @Override
    public FieldSelectorResult accept(final String field) {
        return fieldSelectorResult;
    }

    @Override
    public int maxFieldCount() {
        return Integer.MAX_VALUE;
    }
}

