package org.apache.lucene.document;

public final class FieldMapping {
    private final FieldSelectorResult[] fieldSelectorResults;
    private final int[] fieldNumberToIndex;
    private final int maxFieldCount;

    public FieldMapping(
        final FieldSelectorResult[] fieldSelectorResults,
        final int[] fieldNumberToIndex,
        final int maxFieldCount)
    {
        this.fieldSelectorResults = fieldSelectorResults;
        this.fieldNumberToIndex = fieldNumberToIndex;
        this.maxFieldCount = maxFieldCount;
    }

    public int maxFieldCount() {
        return maxFieldCount;
    }

    public FieldSelectorResult[] fieldSelectorResults() {
        return fieldSelectorResults;
    }

    public int[] fieldNumberToIndex() {
        return fieldNumberToIndex;
    }
}

