package org.apache.lucene.index;

/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Reader;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.AbstractField;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.FieldSelectorResult;
import org.apache.lucene.document.FieldVisitor;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.SegmentMerger.DocIdStream;
import org.apache.lucene.index.SegmentMerger.FieldGroupWithReader;
import org.apache.lucene.index.codecs.Codec;
import org.apache.lucene.index.codecs.MergeState;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.BufferedIndexInput;
import org.apache.lucene.store.Decompressor;
import org.apache.lucene.store.DeflateDecompressor;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.NIOFSDirectory;
import org.apache.lucene.store.PackedIndexedCompressedInputStream;
import org.apache.lucene.store.ZstdDecompressor;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CloseableThreadLocal;
import org.apache.lucene.util.packed_ondisk.PackedInts;

/**
 * Class responsible for access to stored document fields.
 * <p/>
 * It uses &lt;segment&gt;.fdt and &lt;segment&gt;.fdx; files.
 * 
 * @lucene.internal
 */
public interface FieldsReader extends Cloneable, Closeable {
//public abstract class FieldsReader implements Cloneable, Closeable {
  /** Verifies that the code version which wrote the segment is supported. */
//    public void checkCodeVersion(Directory dir, String segment)
//        throws IOException;
/*
    public static FieldsReader getFieldsReader(
        Directory d,
        String segment,
        FieldInfos fn,
        int readBufferSize,
        int docStoreOffset,
        int size)
        throws IOException
    {
        final String indexStreamFN = IndexFileNames.segmentFileName(
            segment,
             "",
             IndexFileNames.FIELDS_INDEX_EXTENSION);
        IndexInput indexStream = d.openInput(indexStreamFN, readBufferSize);
        int format;
        try {
            format = indexStream.readInt();
        } finally {
            indexStream.close();
        }
        switch (format) {
            case StandardFieldsReader.FORMAT:
                return new StandardFieldsReader(
                    d,
                    segment,
                    fn,
                    readBufferSize,
                    docStoreOffset,
                    size);
            default:
                throw new IOException(
                    "Unknown Fields format: " + format);
        }
    }

    public static FieldsReader getFieldsReader(
        Directory d,
        String segment,
        FieldInfos fn)
        throws IOException
    {
        return getFieldsReader(
            d,
            segment,
            fn,
            BufferedIndexInput.BUFFER_SIZE,
            -1,
            0);
    }
*/
//    @Override
    public abstract FieldsReader clone();

    public abstract int size();

    public abstract long fillGroupDocFieldMap(
        Set<String> groupField,
        SegmentMerger.FieldGroupWithReader reusableKey,
        Map<FieldGroupWithReader, DocIdStream> groupDocFieldMap,
        Bits deletedDocs,
        Set<String> storedFields,
        FieldInfos outFieldInfos,
        MergeState.CheckAbort checkAbort)
        throws IOException;

    public abstract Document doc(
        int n,
        FieldSelector fieldSelector)
        throws CorruptIndexException, IOException;

    public abstract void readDocument(final int n, final FieldVisitor visitor)
        throws CorruptIndexException, IOException;

    public abstract void writeDocument(
        int docId,
        int newDocId,
        FieldsWriter out,
        Set<String> storedFields)
        throws IOException;

    public abstract void writeDocument(
        int docId,
        int newDocId,
        FieldsWriter out,
        Set<String> storedFields,
        boolean noIndex)
        throws IOException;

    /** Returns the length in bytes of each raw document in a
    *  contiguous range of length numDocs starting with
    *  startDocID.  Returns the IndexInput (the fieldStream),
    *  already seeked to the starting point for startDocID.*/
    public abstract IndexInput rawDocs(
        int[] lengths,
        int startDocID,
        int numDocs)
        throws IOException;

    public abstract void directIO(boolean direct);
}
