package org.apache.lucene.index;

/**
 * Copyright 2004 The Apache Software Foundation
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

import java.io.Closeable;
import java.io.IOException;

import org.apache.lucene.document.Document;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.FieldVisitor;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.RAMOutputStream;
//import org.apache.lucene.util.packed_native.PackedInts;
import org.apache.lucene.util.packed.PackedInts;

public interface FieldsWriter extends Closeable {
    FieldInfos getFieldInfos();

    void abort();
    void writeField(FieldInfo fi, Fieldable field)
        throws IOException;
    void writeField(
        FieldInfo otherFi,
        byte bits,
        IndexInput data,
        int length)
        throws IOException;

    void newDocument(final int docId, final int fieldCount) throws IOException;
    void newDocumentNoIndex(final int docId, final int fieldCount) throws IOException;

    long getDataStreamPosition();
    void writeIndex(final PackedInts.Mutable srcIndex)
        throws IOException;

    void addRawDocuments(IndexInput stream, int[] lengths, int numDocs)
        throws IOException;

    void addDocument(final int docId, final Document doc) throws IOException;

    void addDocumentNoIndex(final int docId, final Document doc) throws IOException;

    void flushDocument(final int docId, int numStoredFields, RAMOutputStream buffer)
        throws IOException;

    void skipDocument(final int docId) throws IOException;

    Document doc(int n, FieldSelector fieldSelector)
        throws CorruptIndexException, IOException;

    void readDocument(final int n, final FieldVisitor visitor)
        throws CorruptIndexException, IOException;
}
