package org.apache.lucene.index;

/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.RamUsageEstimator;

import ru.yandex.collection.ChunkedIntList;

class ParallelPostingsArray {
  final static int BYTES_PER_POSTING = 3 * (RamUsageEstimator.NUM_BYTES_INT + 1);

  int size;
  final ChunkedIntList textStarts;
  final ChunkedIntList intStarts;
  final ChunkedIntList byteStarts;

  ParallelPostingsArray(final int size) {
    this.size = size;
    textStarts = new ChunkedIntList();
    textStarts.resize(size);
    intStarts = new ChunkedIntList();
    intStarts.resize(size);
    byteStarts = new ChunkedIntList();
    byteStarts.resize(size);
  }

  int bytesPerPosting() {
    return BYTES_PER_POSTING;
  }

  ParallelPostingsArray newInstance(int size) {
    return new ParallelPostingsArray(size);
  }

  ParallelPostingsArray grow() {
    int newSize = ArrayUtil.oversize(size + 1, bytesPerPosting());
    textStarts.resize(newSize);
    intStarts.resize(newSize);
    byteStarts.resize(newSize);
    size = newSize;
    return this;
  }
}

