package org.apache.lucene.store;

public final class AesflateDecompressor implements ReadingDecompressor {
    public static final Decompressor INSTANCE = new AesflateDecompressor();

    public AesflateDecompressor() {
    }

    @Override
    public int decompress(
        final byte[] compressed,
        final int compressedLen,
        final long decompressed,
        final int decompressedLen)
    {
        return ru.yandex.msearch.util.Compress.aesflateDecompress(
            compressed,
            compressedLen,
            decompressed,
            decompressedLen);
    }

    @Override
    public int decompress(
        final long compressed,
        final int compressedLen,
        final long decompressed,
        final int decompressedLen)
    {
        return ru.yandex.msearch.util.Compress.aesflateDecompressBytes(
            compressed,
            compressedLen,
            decompressed,
            decompressedLen);
    }

    @Override
    public int decompress(
        final int fd,
        final long fPos,
        final int compressedLen,
        final long decompressed,
        final int decompressedLen)
    {
        return ru.yandex.msearch.util.Compress.aesflateReadAndDecompress(
            fd,
            fPos,
            compressedLen,
            decompressed,
            decompressedLen);
    }

    @Override
    public String errorDescription(final int code) {
        return Integer.toString(code);
//        return ru.yandex.msearch.util.Compress.aesflateCodeToString(code);
    }

    @Override
    public String toString() {
        return "AesflateDecompressor";
    }
}
