package org.apache.lucene.store;

public interface Compressor {
    static final int OVERHEAD = 64;

    public String id();

    public int compress(
        final byte[] plain,
        final int plainLen,
        final byte[] compressed,
        final int maxCompressedLen);

    public int compress(
        final long plain,
        final int plainLen,
        final long compressed,
        final int maxCompressedLen);

    public default int zeroCompressOverhead() {
        return OVERHEAD;
    }

    public Decompressor decompressor();

    public String errorDescription(int code);
}
