package org.apache.lucene.store;

import ru.yandex.msearch.util.Compress;

public final class DeflateCompressor implements Compressor {
    private final Decompressor decompressor = new DeflateDecompressor();
    private final String id;
    private final int level;

    public DeflateCompressor() {
        this(1);
    }

    public DeflateCompressor(final int level) {
        this.id = null;
        this.level = level;
    }

    @Override
    public String id() {
        return id;
    }

    @Override
    public int compress(
        final byte[] plain,
        final int plainLen,
        final byte[] compressed,
        final int maxCompressedLen)
    {
        return Compress.deflateByteArray(
            plain,
            plainLen,
            compressed,
            maxCompressedLen,
            level);
    }

    @Override
    public int compress(
        final long plain,
        final int plainLen,
        final long compressed,
        final int maxCompressedLen)
    {
        return Compress.deflateRawArray(
            plain,
            plainLen,
            compressed,
            maxCompressedLen,
            level);
    }

    @Override
    public Decompressor decompressor() {
        return decompressor;
    }

    @Override
    public String errorDescription(int code) {
        return decompressor.errorDescription(code);
    }
}
