package org.apache.lucene.store;

public final class DeflateDecompressor implements ReadingDecompressor {
    public static final Decompressor INSTANCE = new DeflateDecompressor();

    public DeflateDecompressor() {
    }

    @Override
    public int decompress(
        final byte[] compressed,
        final int compressedLen,
        final long decompressed,
        final int decompressedLen)
    {
        return ru.yandex.msearch.util.Compress.inflateByteArray(compressed,
            compressedLen, decompressed, decompressedLen);
    }

    @Override
    public int decompress(
        final long compressed,
        final int compressedLen,
        final long decompressed,
        final int decompressedLen)
    {
        return ru.yandex.msearch.util.Compress.inflateBytes(
            compressed,
            compressedLen,
            decompressed,
            decompressedLen);
    }

    @Override
    public int decompress(
        final int fd,
        final long fPos,
        final int compressedLen,
        final long decompressed,
        final int decompressedLen)
    {
        return ru.yandex.msearch.util.Compress.readAndInflateByteArray(fd, fPos,
            compressedLen, decompressed, decompressedLen);
    }

    @Override
    public String errorDescription(final int code) {
        return Integer.toString(code);
    }

    @Override
    public String toString() {
        return "DeflateDecompressor";
    }
}
