package org.apache.lucene.store;

import ru.yandex.msearch.util.Compress;

public final class LZMADecompressor implements ReadingDecompressor {
    @Override
    public int decompress(
        final byte[] compressed,
        final int compressedLen,
        final long decompressed,
        final int decompressedLen)
    {
        return ru.yandex.msearch.util.Compress.lzmaDecompressByteArray(
            compressed,
            compressedLen,
            decompressed,
            decompressedLen);
    }

    @Override
    public int decompress(
        final long compressed,
        final int compressedLen,
        final long decompressed,
        final int decompressedLen)
    {
        return ru.yandex.msearch.util.Compress.lzmaDecompressBytes(
            compressed,
            compressedLen,
            decompressed,
            decompressedLen);
    }

    @Override
    public int decompress(
        final int fd,
        final long fPos,
        final int compressedLen,
        final long decompressed,
        final int decompressedLen)
    {
        return ru.yandex.msearch.util.Compress.lzmaReadAndDecompressByteArray(
            fd,
            fPos,
            compressedLen,
            decompressed,
            decompressedLen);
    }

    @Override
    public String errorDescription(final int code) {
        return Compress.lzmaCodeToString(code);
    }

    @Override
    public String toString() {
        return "LZMADecompressor";
    }
}
