package org.apache.lucene.store;

import ru.yandex.msearch.util.Compress;

import ru.yandex.unsafe.NativeMemory2;

public final class NullDecompressor implements ReadingDecompressor {
    private static final int OSHIBKA = -100500;

    @Override
    public int decompress(
        final byte[] compressed,
        final int compressedLen,
        final long decompressed,
        final int decompressedLen)
    {
        if (compressedLen != decompressedLen) {
            return OSHIBKA;
        }
        NativeMemory2.unboxedWrite(
            decompressed,
            compressed,
            0,
            compressedLen);
        return compressedLen;
    }

    @Override
    public int decompress(
        final long compressed,
        final int compressedLen,
        final long decompressed,
        final int decompressedLen)
    {
        if (compressedLen != decompressedLen) {
            return OSHIBKA;
        }
        NativeMemory2.unboxedCopy(
            compressed,
            decompressed,
            compressedLen);
        return compressedLen;
    }

    @Override
    public int decompress(
        final int fd,
        final long fPos,
        final int compressedLen,
        final long decompressed,
        final int decompressedLen)
    {
        if (compressedLen != decompressedLen) {
            return OSHIBKA;
        }
        return ru.yandex.msearch.util.Compress.pread(
            fd,
            fPos,
            decompressed,
            compressedLen);
    }

    @Override
    public String errorDescription(final int code) {
        if (code == OSHIBKA) {
            return "compressed length != decompressed while "
                + "using Null decompressor";
        } else {
            return "Unknown error code: " + code;
        }
    }

    @Override
    public String toString() {
        return "NullDecompressor";
    }
}
