package org.apache.lucene.store;

import ru.yandex.msearch.util.Compress;

public final class ZstdCompressor implements Compressor {
    public final Decompressor decompressor = new ZstdDecompressor();
    private final String id;
    private final int level;

    public ZstdCompressor(final int level) {
        this.id = "zstd";
        this.level = level;
    }

    @Override
    public String id() {
        return id;
    }

    @Override
    public int compress(
        final byte[] plain,
        final int plainLen,
        final byte[] compressed,
        final int maxCompressedLen)
    {
        return Compress.zstdCompressByteArray(
            plain,
            plainLen,
            compressed,
            maxCompressedLen,
            level);
    }

    @Override
    public int compress(
        final long plain,
        final int plainLen,
        final long compressed,
        final int maxCompressedLen)
    {
        return Compress.zstdCompressRawArray(
            plain,
            plainLen,
            compressed,
            maxCompressedLen,
            level);
    }

    @Override
    public Decompressor decompressor() {
        return decompressor;
    }

    @Override
    public String errorDescription(int code) {
        return decompressor.errorDescription(code);
    }
}
