package org.apache.lucene.store;

import ru.yandex.msearch.util.Compress;

public final class ZstdDecompressor implements ReadingDecompressor {
    @Override
    public int decompress(
        final byte[] compressed,
        final int compressedLen,
        final long decompressed,
        final int decompressedLen)
    {
        return ru.yandex.msearch.util.Compress.zstdDecompressByteArray(
            compressed,
            compressedLen,
            decompressed,
            decompressedLen);
    }

    @Override
    public int decompress(
        final long compressed,
        final int compressedLen,
        final long decompressed,
        final int decompressedLen)
    {
        return ru.yandex.msearch.util.Compress.zstdDecompressBytes(
            compressed,
            compressedLen,
            decompressed,
            decompressedLen);
    }

    @Override
    public int decompress(
        final int fd,
        final long fPos,
        final int compressedLen,
        final long decompressed,
        final int decompressedLen)
    {
        return ru.yandex.msearch.util.Compress.zstdReadAndDecompressByteArray(
            fd,
            fPos,
            compressedLen,
            decompressed,
            decompressedLen);
    }

    @Override
    public String errorDescription(final int code) {
        return Compress.zstdCodeToString(code);
    }

    @Override
    public String toString() {
        return "ZstdDecompressor";
    }
}
