package org.apache.lucene.util.packed_ondisk;

/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import java.io.IOException;

import org.apache.lucene.store.IndexInput;

/**
 * Direct wrapping of 16 bit values to a backing array of shorts.
 * @lucene.internal
 */

public class Direct16 extends PackedInts.ReaderImpl {
  private static final int BITS_PER_VALUE = 16;
  private static final int BYTES_PER_VALUE = 2;

  public Direct16(IndexInput in, int valueCount) {
    super(in, valueCount, BITS_PER_VALUE);
  }

  public long get(final int index) throws IOException {
    return 0xFFFFL & getShort(index);
  }

}
