package ru.yandex.analyzer;

import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;

import java.io.IOException;

/**
 * A {@link TokenFilter} that adds and takes max from result and zero.
 */
public final class AazFilter extends TokenFilter {
    private final double summand;
    private final CharTermAttribute termAtt;

    public AazFilter(final TokenStream in, final double summand) {
        super(in);
        this.summand = summand;
        termAtt = addAttribute(CharTermAttribute.class);
    }

    @Override
    public final boolean incrementToken() throws IOException {
        if (input.incrementToken()) {
            try {
                String str = new String(termAtt.buffer(), 0, termAtt.length());
                double value = Double.parseDouble(str);
                value = Math.max(value + summand, 0d);
                termAtt.setEmpty();
                termAtt.append(Double.toString(value));
            } catch (NumberFormatException e) {
                // do nothing
            }
            return true;
        } else {
            return false;
        }
    }
}
