package ru.yandex.analyzer;

import java.io.IOException;
import java.io.Reader;

import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;

public class BooleanTokenizer extends Tokenizer {
    private static final char[] FAKE_BUF = new char[1];

    private final CharTermAttribute termAtt =
        addAttribute(CharTermAttribute.class);
    private boolean done = false;

    public BooleanTokenizer(final Reader reader) {
        super(reader);
    }

    @Override
    public boolean incrementToken() throws IOException {
        if (done) {
            return false;
        } else {
            done = true;
            if (input.read(FAKE_BUF) == -1) {
                return false;
            } else {
                termAtt.setEmpty();
                termAtt.append('1');
                return true;
            }
        }
    }

    @Override
    public void reset(Reader input) throws IOException {
        super.reset(input);
        done = false;
    }
}

