package ru.yandex.analyzer;

import java.io.Reader;
import org.apache.lucene.analysis.CharTokenizer;
import org.apache.lucene.analysis.Tokenizer; // for javadocs
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.Version;

/**
 * A ComaTokenizer is a {@link Tokenizer} that breaks input sequence by coma
 * character ,
 */

public class ComaTokenizer extends CharTokenizer {
    public ComaTokenizer(Reader in) {
        super(Version.LUCENE_40,in);
    }

    public ComaTokenizer(AttributeSource source, Reader in) {
        super(Version.LUCENE_40, source, in);
    }

    public ComaTokenizer(AttributeFactory factory, Reader in) {
        super(Version.LUCENE_40, factory, in);
    }

    /**
     * Collects only characters which are not coma characters
     * {@link Character#isLetter(char)}.
     */
    @Override
    protected boolean isTokenChar(int c) {
        return c != ',';
    }
}
