package ru.yandex.analyzer;

import java.io.IOException;
import java.io.Reader;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;

import ru.yandex.msearch.FieldConfig;

import ru.yandex.util.string.NormalizingReader;

class TokenizerAndStream {
    public final Tokenizer tokenizer;
    public TokenStream stream;

    TokenizerAndStream(final Tokenizer tokenizer) {
        this.tokenizer = tokenizer;
        stream = tokenizer;
    }
}

public class CustomAnalyzer extends Analyzer {
    private final FieldConfig config;
    private final FilterChainFactory filterFactory;
    private TokenizerAndStream tas = null;

    public CustomAnalyzer(
            final FieldConfig config,
            final FilterChainFactory filterFactory)
    {
        this.config = config;
        this.filterFactory = filterFactory;
    }

    private Reader norm(final Reader reader) {
        if (config.normalizeUtf()) {
            return new NormalizingReader(reader);
        } else {
            return reader;
        }
    }

    @Override
    public TokenStream tokenStream(
        final String fieldName,
        final Reader reader)
        throws IOException
    {
        return filterFactory.createStream(
            config.tokenizer(),
            filterFactory.preprocessor().preprocess(norm(reader)))
            .stream;
    }

    @Override
    public TokenStream reusableTokenStream(
        final String fieldName,
        Reader reader)
        throws IOException
    {
        reader = filterFactory.preprocessor().preprocess(norm(reader));
        if (tas == null) {
            tas = filterFactory.createStream(config.tokenizer(), reader);
        } else {
            tas.tokenizer.reset(reader);
        }
        return tas.stream;
    }
}

