package ru.yandex.analyzer;

import java.io.IOException;
import java.io.Reader;

import java.util.ArrayList;

import ru.yandex.analyzer.preprocessor.FieldPreprocessor;

public class FilterChainFactory extends ArrayList<FilterFactory> {
    private static final long serialVersionUID = 0L;

    private final FieldPreprocessor preprocessor;

    public FilterChainFactory(final FieldPreprocessor preprocessor) {
        this.preprocessor = preprocessor;
    }

    public FieldPreprocessor preprocessor() {
        return preprocessor;
    }

    public TokenizerAndStream createStream(
        final TokenizerType tokenizerType,
        final Reader reader)
    {
        TokenizerAndStream tas =
            new TokenizerAndStream(tokenizerType.createTokenizer(reader));
        for (FilterFactory factory: this) {
            tas.stream = factory.createFilter(tas.stream);
        }
        return tas;
    }
}

