package ru.yandex.analyzer;

import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;

import java.io.IOException;

/**
 * A {@link TokenFilter} that ignores tokens which have specific prefix.
 */
public final class IgnorePrefixFilter extends TokenFilter {
    private final char[] prefix;
    private final CharTermAttribute termAtt;

    public IgnorePrefixFilter(final TokenStream in, final String prefix) {
        super(in);
        this.prefix = prefix.toCharArray();
        termAtt = addAttribute(CharTermAttribute.class);
    }

    @Override
    public final boolean incrementToken() throws IOException {
        if (input.incrementToken()) {
            if (termAtt.length() >= prefix.length) {
                char[] cbuf = termAtt.buffer();
                for (int i = 0; i < prefix.length; ++i) {
                    if (prefix[i] != cbuf[i]) {
                        return true;
                    }
                }
                return incrementToken();
            } else {
                return true;
            }
        } else {
            return false;
        }
    }
}
