package ru.yandex.analyzer;

import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;

import java.io.IOException;

/**
 * A {@link TokenFilter} that truncate tokens to the specified size.
 */
public final class Int2HexFilter extends TokenFilter
{
    private static final char[] HEX_CHARS = {
        '0', '1', '2', '3', '4', '5', '6', '7',
        '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'
    };
    public static final int SHIFT = 4;
    public static final int MASK = 0xf;

    private CharTermAttribute termAtt;
    private final StringBuilder sb;

    public Int2HexFilter(TokenStream in) {
        super(in);
        termAtt = addAttribute(CharTermAttribute.class);
        sb = new StringBuilder();
    }

    private static int parseInt(final char[] buf, final int len) {
        int num  = 0;
        int sign = -1;
        final char ch  = buf[0];
        if (ch == '-') {
            sign = 1;
        } else {
            num = '0' - ch;
        }
        // Build the number.
        int i = 1;
        while (i < len) {
            num = num * 10 + '0' - buf[i++];
        }
        return sign * num;
    }

    @Override
    public final boolean incrementToken() throws IOException {
        if (input.incrementToken()) {
            sb.setLength(0);
            char[] buffer = termAtt.buffer();
            int len = termAtt.length();
            int value = parseInt(buffer, len);
            int i = 0;
            byte b;
            b = (byte) (value >> 24);
            buffer[i++] = HEX_CHARS[(b >>> SHIFT) & MASK];
            buffer[i++] = HEX_CHARS[b & MASK];
            b = (byte) (value >> 16);
            buffer[i++] = HEX_CHARS[(b >>> SHIFT) & MASK];
            buffer[i++] = HEX_CHARS[b & MASK];
            b = (byte) (value >> 8);
            buffer[i++] = HEX_CHARS[(b >>> SHIFT) & MASK];
            buffer[i++] = HEX_CHARS[b & MASK];
            b = (byte) value;
            buffer[i++] = HEX_CHARS[(b >>> SHIFT) & MASK];
            buffer[i++] = HEX_CHARS[b & MASK];

            termAtt.setLength(i);
            return true;
        } else {
            return false;
        }
    }
}
