package ru.yandex.analyzer;

import java.io.Reader;
import org.apache.lucene.analysis.CharTokenizer;
import org.apache.lucene.analysis.Tokenizer; // for javadocs
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.Version;

/**
 * A LFTokenizer is a {@link Tokenizer} that breaks input sequence by LF
 * character \n
 */

public class LFTokenizer extends CharTokenizer
{
    public LFTokenizer(Reader in)
    {
    	super(Version.LUCENE_40,in);
    }

    public LFTokenizer(AttributeSource source, Reader in)
    {
        super(Version.LUCENE_40, source, in);
    }

    public LFTokenizer(AttributeFactory factory, Reader in)
    {
        super(Version.LUCENE_40, factory, in);
    }

    /**
     * Collects only characters which are not LF characters
     * {@link Character#isLetter(char)}.
     */
    @Override
    protected boolean isTokenChar(int c)
    {
        return c != '\n' && c != '\r';
    }
}
