package ru.yandex.analyzer;

import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;

import java.io.IOException;

/**
 * A {@link TokenFilter} that multiplies and takes floor of the number.
 */
public final class MafFilter extends TokenFilter {
    private final double multiplicand;
    private final CharTermAttribute termAtt;

    public MafFilter(final TokenStream in, final double multiplicand) {
        super(in);
        this.multiplicand = multiplicand;
        termAtt = addAttribute(CharTermAttribute.class);
    }

    @Override
    public final boolean incrementToken() throws IOException {
        if (input.incrementToken()) {
            try {
                String str = new String(termAtt.buffer(), 0, termAtt.length());
                double value = Double.parseDouble(str);
                termAtt.setEmpty();
                termAtt.append(Double.toString(value * multiplicand));
            } catch (NumberFormatException e) {
                // do nothing
            }
            return true;
        } else {
            return false;
        }
    }
}
