package ru.yandex.analyzer;

import java.io.IOException;

import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;

public class PrefixSubstringsFilter extends TokenFilter {
    private final int maxSubstringLength;

    private char[] tokenBuffer;
    private int tokenLength;
    private int tokens = 0;

    private int tokensPos = 0;
    private CharTermAttribute termAtt;
    private PositionIncrementAttribute posAtt;

    public PrefixSubstringsFilter(final TokenStream in, final int maxSubstringLength) {
        super(in);

        this.maxSubstringLength = maxSubstringLength;
        termAtt = addAttribute(CharTermAttribute.class);
        posAtt = addAttribute(PositionIncrementAttribute.class);
    }
    /**
     * Returns the next token in the stream, or null at EOS
     */
    @Override
    public final boolean incrementToken() throws IOException {
        if (tokensPos < tokens) {
            termAtt.setEmpty();
            if (tokensPos == 0) {
                termAtt.append(tokenBuffer, 0, tokenLength);
            } else {
                termAtt.append(tokenBuffer, 0, tokensPos);
            }

            tokensPos += 1;
            posAtt.setPositionIncrement(0);
            return true;
        } else {
            if (input.incrementToken()) {
                if (termAtt.length() <= maxSubstringLength) {
                    tokens = termAtt.length();
                } else {
                    tokens = maxSubstringLength + 1;
                }

                tokensPos = 0;
                tokenBuffer = new char[termAtt.length()];
                tokenLength = termAtt.length();

                System.arraycopy(termAtt.buffer(), 0, tokenBuffer, 0, termAtt.length());
                return true;
            } else {
                return false;
            }
        }
    }

    @Override
    public void reset() throws IOException {
        tokensPos = 0;
        tokens = 0;
        tokenBuffer = null;
        tokenLength = 0;
        super.reset();
    }
}
