package ru.yandex.analyzer;

import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;

public class PrefixSubstringsFilterFactory implements FilterFactory {
    private final int maxSubstringSize;

    public PrefixSubstringsFilterFactory(final int maxSubstringSize) {
        this.maxSubstringSize = maxSubstringSize;
    }

    @Override
    public TokenFilter createFilter(final TokenStream previous) {
        return new PrefixSubstringsFilter(previous, maxSubstringSize);
    }

    public int maxSubstringSize() {
        return maxSubstringSize;
    }
}
