package ru.yandex.analyzer;

import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;

import java.io.IOException;

public class ReplaceCharFilter extends TokenFilter {
    private final char from;
    private final char to;
    private final CharTermAttribute termAtt;

    public ReplaceCharFilter(final TokenStream in, final char from,
        final char to)
    {
        super(in);
        this.from = from;
        this.to = to;
        termAtt = addAttribute(CharTermAttribute.class);
    }

    @Override
    public final boolean incrementToken() throws IOException {
        if (input.incrementToken()) {
            char[] cbuf = termAtt.buffer();
            for (int i = 0; i < cbuf.length; ++i) {
                if (cbuf[i] == from) {
                    cbuf[i] = to;
                }
            }
            return true;
        } else {
            return false;
        }
    }
}
